open Term

(* theorems *)
type theorem =
  | KB of (Trs.t*Trs.t)
  | JK of (Trs.t*Trs.t)
  | RL of (Trs.t*Trs.t)
  | MO of (Trs.t*Trs.t)
  | DC of (Trs.t*Trs.t)
  | SCP of (Trs.t*Trs.t)
  | PC of (Trs.t*Trs.t)
  | UC of (Trs.t*Trs.t)
  | OC of (Trs.t*Trs.t)
  | CPC of (Trs.t*Trs.t)
  | NC of unit
  | SC of (Trs.t*Trs.t)
  | COM of (theorem list)
type peak = t*t*t

val commute : Trs.t -> Trs.t -> (theorem,peak) Result.t
val cr      : Trs.t -> (theorem,peak) Result.t

val thm_description : theorem -> string
val show_proof      : theorem -> unit

(* Knuth and Bendix 1964 *)
val kb1    : Trs.t -> (theorem,peak) Result.t
val kb2    : Trs.t -> Trs.t -> (theorem,peak) Result.t
(* Mutually orthogonality *)
val thm_MO : Trs.t -> Trs.t -> (theorem,peak) Result.t
(* Jouannaud and Kirchner 1986 *)
val thm_JK : Trs.t -> Trs.t -> (theorem,peak) Result.t
(* Development Closedness: Yoshida Aoto Toyama 2009 *)
val thm_DC : Trs.t -> Trs.t -> (theorem,peak) Result.t
(* weighted Rule Labeling: V Oostrom 2008, Aoto 2010 *)
val thm_RL : Trs.t -> Trs.t -> (theorem,peak) Result.t
(* strictly commuting: Geser 90 *)
val thm_SC : Trs.t -> Trs.t -> (theorem,peak) Result.t
(* parallel closedness (CR) *)
val thm_toyama81: Trs.t -> Trs.t -> (theorem,peak) Result.t
val thm_OPC: Trs.t -> Trs.t -> (theorem,peak) Result.t
(* check non commutation *)
val noncomm: Trs.t -> Trs.t -> (theorem,peak) Result.t
(* apply each theorems directly *)
val direct0: Trs.t -> Trs.t -> (theorem,peak) Result.t
(* apply each theorems directly (cached) *)
val direct : Trs.t -> Trs.t -> (theorem,peak) Result.t
(* locally commutation *)
val wcomm  : Trs.t -> Trs.t -> (theorem,peak) Result.t
val kwcomm : int -> Trs.t -> Trs.t -> (theorem,peak) Result.t

val wcr   : Trs.t -> (theorem,peak) Result.t
val kwcr  : int -> Trs.t -> (theorem,peak) Result.t

(* caching *)
val cache_on  : unit -> unit
val cache_off : unit -> unit
