open Term

type command 'a = (string -> 'a) -> string * out_channel -> string list -> 'a

(* run command and read all stdout *)
val run           : string -> string
val run_with      : 'a command
val run_with_save : 'a command


(* utility *)
val write_file : string -> string list -> unit
val finally : 'a -> ('a -> 'b) -> ('a -> unit) -> 'b
val read_lines : in_channel -> string list
val read_all : in_channel -> string


(* apply function, and measure processing time *)
val chronicle : ('a -> 'b) -> 'a -> 'b * float
(* output processing time to stderr *)
val watcher   : string -> ('a -> 'b) -> 'a -> 'b
(* watcher for longer label *)
val watcher_l : string -> ('a -> 'b) -> 'a -> 'b
