open Term
open Step

(* NOTE: pair is joinable by ->1st and 2nd<- *)
val join    : int -> Trs.t -> Trs.t -> t * t -> bool
val join_by : stepSs list -> stepSs list -> t * t -> bool
val goto    : int -> (t -> t list) -> t -> t -> bool
val unjoin     : Trs.t -> Trs.t -> t * t -> bool

(* complex *)
val jj    : Trs.t list -> Trs.t list -> t * t
  -> (rewrite list * rewrite list) list
val jj_ex : stepSs list -> stepSs list -> t * t
  -> (rewrite list * rewrite list) list

val k_join : int -> Trs.t -> Trs.t -> t * t -> (rewrite list * rewrite list) list
val is_k_join : int -> Trs.t -> Trs.t -> t * t -> bool

val joinable   : Trs.t list -> Trs.t list -> t * t -> (unit,t*t) Result.t
val k_joinable : int -> Trs.t -> Trs.t -> t * t -> (unit,t*t) Result.t

(* light weight *)
val jj_light   : int -> Trs.t -> Trs.t -> t * t -> (unit,t*t) Result.t

val show_seq   : string -> rewrite list -> unit
val show_joins : (rewrite list * rewrite list) list -> unit

(* for jj *)
val cache_on     : unit -> unit
val cache_off    : unit -> unit
(* for jj_light *)
val light_on     : unit -> unit
val light_off    : unit -> unit

(* table opration for jj *)
val reset_table : unit -> unit
val show        : unit -> unit
