(* $Id: listset.ml,v 1.2 2004/08/12 13:59:04 nao Exp $ *)
(* Set theoretical operations for `list' *)

let empty = [] 

let singleton x = [x]

let is_empty xs = xs = []

let rec unique = function
  | [] -> []
  | x :: xs -> x :: unique (List.filter (fun y -> x <> y) xs)

let add x xs = 
  if List.mem x xs then xs else x :: xs

let subset xs ys = 
  List.for_all (fun x -> List.mem x ys) xs

let intersect xs ys = List.exists (fun x -> List.mem x ys) xs

let equal xs ys = subset xs ys && subset ys xs

let union xs ys = unique (xs @ ys)

let big_union xss = unique (List.concat xss)

let inter xs ys = 
  List.filter (fun x -> List.mem x ys) (unique xs)

let diff xs ys = 
  List.filter (fun x -> not (List.mem x ys)) (unique xs)

let remove x xs = diff xs [x]

let concat xss = unique (List.concat xss)

let minimal_aux leq xs ys =
  let eq x y = leq x y && leq y x in
  List.filter
    (fun y -> (List.for_all (fun x -> eq x y || not(leq x y)) xs))
    ys

let minimal ?(leq=(<=)) xs =
  minimal_aux leq xs xs

let maximal ?(leq=(<=)) xs =
  let eq x y = leq x y && leq y x in
  minimal_aux (fun a b -> not (leq a b) && not (eq a b)) xs xs
