val init : int -> (int -> 'a) -> 'a list

val ix : ?i:int -> 'a list -> (int * 'a) list

val unique : 'a list -> 'a list

val copy : int -> 'a -> 'a list

(* combinatorial functions *)

val product : ('a -> 'b -> 'c) -> 'a list -> 'b list -> 'c list

val pi : 'a list list -> 'a list list
  (** pi [l1; .. ; lN] returns the list of the certesian product l1 * .. * lN *)

val tri : 'a list -> ('a * 'a) list

val nth_power : 'a list -> int -> 'a list list

val power : 'a list -> 'a list list

val suffix : 'a list -> 'a list list

val prefix : 'a list -> 'a list list

val interleave : 'a -> 'a list -> 'a list list

val permutation : 'a list -> 'a list list

val transpose : 'a list list -> 'a list list

val group : ('a * 'b) list -> ('a * 'b list) list

val group_by : ('a -> 'b) -> 'a list -> ('b * 'a list) list

val count : 'a list -> ('a * int) list

val fold_left1 : ('a -> 'a -> 'a) -> 'a list -> 'a

val concat_map : ('a -> 'b list) -> 'a list -> 'b list 

(* list operations for integer lists. *)

val max : int list -> int

val min : int list -> int

val sum : int list -> int

val interval : int -> int -> int list

val index : ?i:int -> 'a list -> (int * 'a) list 

val take : int -> 'a list -> 'a list

val drop : int -> 'a list -> 'a list

(* misc *)
val count_iter : ?n:int -> ('a -> unit) -> 'a list -> unit
