open Term

(* term comparison *)
val compare : t -> t -> int

(**** Unification ****)
val matcher      : t -> t -> (string * t) list
val matchers     : Trs.t -> t -> (Rule.t * ((string * t) list)) list

val instance_of  : t -> t -> bool
val variant      : t -> t -> bool
val variant_rule : Rule.t -> Rule.t -> bool

val mgu          : (t * t) list -> (string * t) list
val unifiable    : (t * t) list -> bool

(** tcap function **)
val tcap         : Trs.t -> t -> t

(**** Critical Pair ****)
val simple_cp  : (t * t) list -> (t * t) list

val is_overlap : (Rule.t * position * Rule.t) -> bool
(* rename second Trs.t *)
val overlaps   : Trs.t -> Trs.t -> (Rule.t * position * Rule.t) list

(* b <-p a -> c *)
val cp_overlap : (Rule.t * position * Rule.t) list -> (t * position * t * t) list

(* critical peaks *)
val cpp         : Trs.t -> (t * position * t * t) list
val cpp2        : Trs.t -> Trs.t -> (t * position * t * t) list (* rhs is rewrited by root redex *)
val cpp2r       : Trs.t -> Trs.t -> (t * position * t * t) list (* lhs is rewrited by root redex *)
val cpp2_all    : Trs.t -> Trs.t -> (t * position * t * t) list
val cpp_in      : Trs.t -> Trs.t -> (t * position * t * t) list
val cpp_out     : Trs.t -> Trs.t -> (t * position * t * t) list

(* critical pairs *)
val cp2        : Trs.t -> Trs.t -> (t * t) list (* rhs is rewrited by root redex *)
val cp2r       : Trs.t -> Trs.t -> (t * t) list (* lhs is rewrited by root redex *)
val cp2_all    : Trs.t -> Trs.t -> (t * t) list
val cp_in      : Trs.t -> Trs.t -> (t * t) list
val cp_out     : Trs.t -> Trs.t -> (t * t) list

(* sorted critical pairs *)
val cp_        : Trs.t -> (t * t) list
val cp2_       : Trs.t -> Trs.t -> (t * t) list (* rhs is rewrited by root redex *)
val cp2r_      : Trs.t -> Trs.t -> (t * t) list (* lhs is rewrited by root redex *)
val cp2_all_   : Trs.t -> Trs.t -> (t * t) list
val cp_in_     : Trs.t -> Trs.t -> (t * t) list
val cp_out_    : Trs.t -> Trs.t -> (t * t) list

(* special critical pairs *)
val simultaneous_cp2 : Trs.t -> Trs.t -> (t * t) list
val simultaneous_cp  : Trs.t -> (t * t) list
val parallel_cpp2    : Trs.t -> Trs.t -> (t * position list * t * t) list
val parallel_cpp     : Trs.t -> (t * position list * t * t) list
val parallel_cp2     : Trs.t -> Trs.t -> (t * t) list
val parallel_cp      : Trs.t -> (t * t) list
val parallel_overlaps: Trs.t -> Trs.t -> (t * (Rule.t * position) list * t * (Rule.t * position) * t) list

(* Property about Critical Pair *)
val is_OH  : Trs.t -> bool
val is_WMO : Trs.t -> Trs.t -> bool
