open Format
open Formatx
open Iroiro
open Unix

type t =
  | C of t list | D of t list
  | Geq of string * string | Gt of string * string | Eq of string * string

let rec print_c ppf = function
  | Gt (x, y)  -> fprintf ppf "(> %s %s)" x y
  | Geq (x, y) -> fprintf ppf "(>= %s %s)" x y
  | Eq (x, y)  -> fprintf ppf "(= %s %s)" x y
  | C [] -> fprintf ppf "true"
  | D [] -> fprintf ppf "false"
  | C [c] -> print_c ppf c
  | D [c] -> print_c ppf c
  | C cs -> fprintf ppf "(and %a)" (print_list print_c " ") cs
  | D cs -> fprintf ppf "(or %a)" (print_list print_c " ") cs

let print_var_type ppf x = fprintf ppf "(%s Int)" x

let print_problem ppf (vars, t) = 
  fprintf ppf "(benchmark unknown@.";
  fprintf ppf ":logic QF_NIA@.";
  fprintf ppf ":extrafuns (%a)@." (print_list print_var_type " ") vars;
  fprintf ppf ":formula %a)@." print_c t
    
let try_finally x ~f g =
  try let y = f x in g x; y with e -> g x; raise e

let sat ~tool vars t =
  let s = Filename.temp_file "" ".smt" in
  try_finally (open_out s) close_out ~f:begin fun ch -> 
    fprintf (formatter_of_out_channel ch) "%a%!"
      print_problem (vars, t)
  end;
  let f ch =
    Minismt_parser.toplevel Minismt_lexer.lex (Lexing.from_channel ch) in
  let result =
    try
      try_finally (open_process_in (sprintf "%s %s" tool s)) ~f close_process_in
    with 
      End_of_file -> None in
  Sys.remove s;
  result
