open Term
open Substitution
open Format

type t = Rule.t * int list * Rule.t * Substitution.t

(* Overlaps *)
let overlap_aux rule1 rule2 =
  let l1, r1 = Rule.rename rule1
  and l2, r2 = Rule.rename rule2 in
  [ (l1, r1), p, (l2, r2), mgu (subterm_at p l2) l1
  | p <- function_positions l2; 
    unifiable (subterm_at p l2) l1 && 
    (p <> [] || not (Rule.variant (l1, r1) (l2, r2))) ] 

let overlap2 rules1 rules2 = 
  Listset.unique
    [ x | rule1 <- rules1; rule2 <- rules2; 
          x <- overlap_aux rule1 rule2 ]

let overlap rules = overlap2 rules rules

let root_overlap (_, p, _, _) = p = []

(* Critical pairs *)
let cp_of_overlap ((l1, r1), p, (l2, r2), mu) =
  (Term.substitute mu (replace l2 r1 p), Term.substitute mu r2)

(* Critical peak *)
let critical_peak_of_overlap ((l1, r1), p, (l2, r2), mu) =
  (Term.substitute mu (replace l2 r1 p), 
   Term.substitute mu l2,
   Term.substitute mu r2)

let cp2 rules1 rules2 = 
  [ cp_of_overlap o | o <- overlap2 rules1 rules2 ]

let cp rules = cp2 rules rules

let mutual_cp rules1 rules2 =
  Listx.unique (cp2 rules1 rules2 @ cp2 rules2 rules1)

(* Critical pair steps *)
let always_true (_:Rule.t) = true

let fst_cps_of_overlap ((_, r1), p, (l2, _), mu) =
  (substitute mu l2, substitute mu (replace l2 r1 p))

let snd_cps_of_overlap (_, p, (l2, r2), mu) =
  (substitute mu l2, substitute mu r2)

let cps_of_overlap o = [fst_cps_of_overlap o; snd_cps_of_overlap o]

let cps2 ?(p = always_true) rules1 rules2 =
  [ x | o <- overlap2 rules1 rules2; p (cp_of_overlap o); 
        x <- cps_of_overlap o]

let cps ?(p = always_true) rules = cps2 ~p rules rules

let mutual_cps ?(p = always_true) rules1 rules2 =
  Listx.unique (cps2 ~p rules1 rules2 @ cps2 ~p rules2 rules1)

(* Overlapping check *)
let is_overlap rule1 p rule2 =
  let l1, r1 = Rule.rename rule1 
  and l2, r2 = Rule.rename rule2 in
  unifiable l1 (subterm_at p l2) && 
  (p <> [] || not (Rule.variant (l1, r1) (l2, r2)))

let overlapping_aux (((l1, r1) as rule1), ((l2, r2) as rule2)) =
  List.exists 
    (fun p -> is_overlap rule1 p rule2)
    (function_positions l2)

let overlapping rules = 
  List.exists overlapping_aux [ x,y | x <- rules; y <- rules ]

let non_overlapping rules = not (overlapping rules)

(* strong non-overlappingness *)

let ren_rules rs = [ ren l, r | l, r <- rs ]

let sno1 ss rs = overlap2 (ren_rules ss) (ren_rules rs) = []

let sno ss rs = sno1 ss rs && sno1 rs ss

(* joinability of S-overlap *)
(*

let ecp_joinable1 n rs ss ((l1, r1), p, (l2,r2)) = 
  let l2p = subterm_at p l2 in 
  not (unifiable (ren l1) (ren l2p)) ||
  (unifiable l2p l1 &&
   (let mu = mgu l2p l1 in 
    let cp = cp_of_overlap ((l1,r1), p, (l2,r2), mu) in
    Rewriting.joinable n (rs @ ss) cp))

let ecp_joinable n rs ss =
  List.for_all (ecp_joinable1 n rs ss)
    [ rename (l1,r1), p, rename (l2,r2) 
    | l1, r1 <- rs; l2, r2 <- rs; p <- function_positions l2 ]
*)
