open Term

let add p q = p@q

let adds p qs = List.map (add p) qs

(* raise exception when p is not prefix of q *)
let rec delete q p = match (q,p) with
    i::q0,j::p0 when i = j -> delete q0 p0
  | _, [] -> q
  | _ -> invalid_arg "Positions.delete: second argument is not prefix"

let deletes qs p = List.map (delete p) qs


(** Poisoning **)
let below_of p q = p <> q && List.mem q (Listx.prefix p)

let above_of p q = p <> q && List.mem p (Listx.prefix q)

let below_equal p q = p = q || below_of p q

let above_equal p q = p = q || above_of p q

let rec parallel p q = match (p,q) with
    i::p', j::q' -> i <> j || parallel p' q'
  | _            -> false

let parallel_list ps qs =
  List.for_all
    (fun q -> List.for_all (fun p -> parallel p q) ps)
    qs

(* p \not> q *)
let not_below_of p q = parallel p q || p = q || above_of p q

(* P \not> Q <=> not q < p for all p in P and q in Q *)
let not_below_of_list ps qs =
  List.for_all
    (fun p ->
      List.for_all (fun q -> not (above_of q p)) qs)
    ps

let upside_closed p q  = List.length q >= List.length p

let outside_closed p q = not (below_of p q)

let stable_positions rs t =
  function_positions (Match.tcap rs t)

let strongly_outermost_positions rs t =
  variable_positions (Match.tcap rs t)

let prefix_stable_positions rs t =
  Listset.union
    (stable_positions rs t)
    (strongly_outermost_positions rs t)

let positions_under f t ps =
  try
    Listx.concat_map
      (fun p -> List.map (add p) (f (subterm_at p t)))
      ps
  with Failure _ ->
    invalid_arg "Positions.positions_under: invalid positions"

let prefix_order p q = parallel p q || above_of p q

let rec chains_aux = function
    []  -> 0
  | p::ps ->
      let belows = List.filter (above_equal p) ps in
      max (chains_aux ps) (1 + chains_aux belows)

let chains ps = chains_aux (List.sort compare ps)
