open Term

(* operation *)
val add : position -> position -> position
val adds : position -> position list -> position list
val delete : position -> position -> position
val deletes : position list -> position -> position list

(* comparison *)
val below_of : position -> position -> bool
val above_of : position -> position -> bool
val below_equal : position -> position -> bool
val above_equal : position -> position -> bool
val parallel : position -> position -> bool
val parallel_list : position list -> position list -> bool
val not_below_of : position -> position -> bool
val not_below_of_list : position list -> position list -> bool
val upside_closed : position -> 'b list -> bool
val outside_closed : position -> position -> bool

(* named positions *)
val stable_positions : Trs.t -> Term.t -> position list
val strongly_outermost_positions : Trs.t -> Term.t -> position list
val prefix_stable_positions : Trs.t -> Term.t -> position list
val prefix_order : position -> position -> bool

(* relative position *)
val positions_under : (Term.t -> position list) -> Term.t -> position list -> position list
val chains : position list -> int
