type opt =
  | B of bool ref
  | I of int  ref

let show = function
  | B b -> string_of_bool !b
  | I x -> string_of_int !x

let getB = function
  | B x -> x
  | I _ -> invalid_arg "Ref.getB"

(* flag for mode change *)
let cr_mode = ref false

(* refs for command line option *)
let no_proof     = ref false
let no_decompose = ref false
let no_ll        = ref false
let no_comm      = ref false
let fc           = ref false
let add_joins    = ref false
let reduce       = ref false
let reduce_joins = ref false
let k            = ref 7 (* lucky seven *)
let l            = ref 3

(* internal description for debugging *)
let dic_options =
  [ B no_proof    , "no_proof"
  ; B no_decompose, "no_decompose"
  ; B no_ll       , "no_ll"
  ; B no_comm     , "no_comm"
  ; B fc          , "forwarding"
  ; B add_joins   , "add join sequences of critical pairs as rules"
  ; B reduce      , "reducing"
  ; B reduce_joins, "reducing joinable seuqneces"
  ; I k           , "k"
  ; I l           , "l"
  ]

(** Flags for criteria **)
(* all false <==> there is no off flag *)
let jk         = ref false (* including jka, jkc, jkac and jkacc *)
let kb         = ref false
let jka        = ref false
let jkc        = ref false
let jkac       = ref false
let dc         = ref false
let mo         = ref false
let sic        = ref false
let sc         = ref false
let rl         = ref false
let tcap       = ref false
let pc         = ref false
let almost_pc  = ref false
let toyama81   = ref false
let gramlich96 = ref false
let uc         = ref false
let puc        = ref false
let oc         = ref false
let opc        = ref false

(* use flag controle for usable criteria *)
let dic_jks =
  [ B jka , "jka"
  ; B jkc , "jkc"
  ; B jkac, "jkac"
  ]

let dic_base_thms =
  [ B dc        , "Developmen closedness"
  ; B mo        , "Mutually orthogonal"
  ; B sc        , "Strongly commute"
  ; B sic       , "Simultaneous closedness"
  ; B rl        , "Rule labeling"
  ; B kb        , "Knuth-Bendix"
  ; B jk        , "Journard-Kirchner"
  ; B tcap      , "Tcap"
  ; B pc        , "Huet's parallel closedness (1979)"
  ; B almost_pc , "almost parallel closedness (1988)"
  ; B toyama81  , "Toyama's parallel closedness (1981)"
  ; B gramlich96, "Gramlich's parallel closedness (1996)"
  ; B uc        , "Upside-closedness"
  ; B puc       , "Parallel Upside-closedness"
  ; B oc        , "Outside-closedness"
  ; B opc       , "Parallel Outside-closedness"
  ]
let dic_all_thms = dic_base_thms @ dic_jks

let flag = ref true

let print_options () =
  List.iter
    (fun (b,s) -> Format.printf "%s = %s@." s (show b))
    dic_options
let print_flags () =
  List.iter
    (fun (b,s) -> Format.printf "%s = %s@." s (show b))
    dic_all_thms

let config_jks () =
  if !jk then
    (jkac := true; jka := true; jkc := true)
  else if List.exists (fun (opt,s) -> !(getB opt)) dic_jks then
    (jk := true; kb := true)
  else
    ()

let flag_off dic =
  List.iter (fun (opt, s) -> (getB opt) := false) dic

let deprecated_common  = []
(* not work in commutation *)
let deprecated_comm = ["tcap"]

let flag_on flags =
  if List.for_all (fun (opt, s) -> not !(getB opt)) flags then
    List.iter (fun (opt,s) -> (getB opt) := true) flags
  else
    ()

let confluence_flag_on () =
  if not !flag then
      flag_off dic_all_thms
  else
    (* if all flags are disabled then enable them *)
    flag_on [opt,s | opt,s <- dic_all_thms;
                     not (List.mem s deprecated_common)];
    (* flag jk enable other sub flags [jka;jkc;jkac] and kb *)
    config_jks ()

let commute_flag_check () =
  match [s | opt,s <- dic_all_thms;
             List.mem s (deprecated_common @ deprecated_comm);
             !(getB opt)] with
  | [] -> ()
  | unsupported_flags ->
      begin
        Format.eprintf
          "unsupported flags are given:\n%s@."
          (String.concat "," unsupported_flags);
        exit 1;
      end

let commute_flag_on () =
  if not !flag then
      flag_off dic_all_thms
  else
    (* if all flags are disabled then enable them *)
    let deprecated_flags = deprecated_common @ deprecated_comm in
    flag_on [opt,s | opt,s <- dic_all_thms;
                     not (List.mem s deprecated_flags)];
    config_jks ()

(* let smt_solver = ref "yices-smt2" *)
let smt_solver = ref "z3"

let use_stdin = ref false (* automatically expand input problems *)
let verbose   = ref false (* show detailed inrmation *)
let show_time = ref false (* associate to Console.watcher *)
let dump_file = ref (None : string option) (* output dir for debug information *)
let test      = ref false

let set_smt_solver tool = smt_solver := tool
let set_dump path        = dump_file := Some path
