open Term

(* result contained proof *)
type t 'a 'b =
  | YES of 'a
  | NO of 'b
  | MAYBE

let is_YES = function
  | YES _ -> true
  | _     -> false

let not_YES r = not (is_YES r)

let is_NO = function
  | NO _ -> true
  | _    -> false

let not_NO r = not (is_NO r)

let is_MAYBE = function
  | MAYBE -> true
  | _     -> false
let not_MAYBE r = not (is_MAYBE r)

let (>>=) r f = match r with
  | MAYBE  -> MAYBE
  | yesno  -> f yesno

let (<|>) r1 r2 = match r1 with
  | YES x -> YES x
  | NO x  -> NO x
  | MAYBE -> r2

let rec exists p = function
  | []    -> MAYBE
  | x::xs -> match p x with
    | MAYBE -> exists p xs
    | yesno -> yesno

let rec sequence = function
  | []          -> YES []
  | MAYBE::_    -> MAYBE
  | (NO x)::_   -> NO x
  | (YES x)::xs ->
      match sequence xs with
      | YES ys -> YES (x::ys)
      | other  -> other

let rec sequence_with f = function
  | []    -> YES []
  | x::xs -> match f x with
    | MAYBE -> MAYBE
    | NO x  -> NO x
    | YES x ->
        match sequence_with f xs with
        | YES ys -> YES (x::ys)
        | other  -> other

let print_result = function
  | YES p    -> Format.printf "YES@.%s@." p
  | NO (s,t) -> Format.printf "NO@.The pair is not joinable:@.%a@.and@.%a@." print s print t
  | MAYBE    -> Format.printf "MAYBE@."
