open Term
open Substitution

let rec rewrite_root1 t = function
  | [] -> false, t
  | (l, r) :: rules ->
      try
	true, substitute (pattern_match l t) r
      with
	Not_matched -> rewrite_root1 t rules

let rec rewrite1_aux rules = function
  | V _ as t -> false, t
  | F (f, ts) ->
      let l = [ rewrite1_aux rules ti | ti <- ts ] in
      let b, u = rewrite_root1 (F (f, [ t | _, t <- l ])) rules in
      b || List.exists (fun (b, _) -> b) l, u

let rec nf rules t =
  let b, u = rewrite1_aux rules t in
  if b then nf rules u else t

let root_step rules s = 
  Listx.unique
    [ substitute (pattern_match l s) r 
    | (l, r) <- rules; is_instance_of s l ]

let rewrite rules s =
  Listx.unique
    [ replace s t p 
    | p <- positions s; 
      t <- root_step rules (subterm_at p s) ]

let rewrite_with rule p s =
  match root_step [rule] (subterm_at p s) with
    [t] -> replace s t p
  | []  -> let err = Format.asprintf "%a with %a at %a@."
                   Term.print s Rule.print rule Term.print_position p
           in
           failwith ("rewrite_with: no reduct " ^ err)
  | _   -> failwith "rewrite_with: does not reachable"

let rec reachable_aux n rules ss ts =
  if n = 0 then ss else
  let us = 
    Listx.unique 
      [ u | t <- ts; u <- rewrite rules t; not (List.mem u ss) ] in
  reachable_aux (n - 1) rules (us @ ss) us

let reachable n rules ts = reachable_aux n rules ts ts

let rec reachable_all_aux rules ss ts =
  let us = 
    Listx.unique 
      [ u | t <- ts; u <- rewrite rules t; not (List.mem u ss) ] in
  if us = [] then ss else
    reachable_all_aux rules (us @ ss) us

let reachable_all rules ts = reachable_all_aux rules ts ts

let joinable n rules (s, t) = 
  Listset.intersect (reachable n rules [s]) (reachable n rules [t]) 

let joinable_by step1 step2 (s, t) =
  Listset.intersect (step1 s) (step2 t)

(* multistep R s = { t | s -o->R t } *)

let rec multistep rules = function
  | V _ as s -> [s]
  | F (f, ss) as s ->
      Listx.unique
	(s :: root_multistep rules s @
	 [ F (f, ts) | ts <- Listx.pi [ multistep rules s | s <- ss ] ])
and multistep_subst rules subst =
  Listx.pi [ [ x, t | t <- multistep rules s ] | x, s <- subst ]
and root_multistep rules s =
  Listx.unique
    [ substitute subst r 
    | (l, r) <- rules;
      is_instance_of s l;
      subst <- multistep_subst rules (pattern_match l s) ]

(*
let a = F ("a", []);;
let s(x) = F ("s", [x]);;
let f(x) = F ("f", [x]);;
let rs = Read.read_trs "/home/nao/E/13cr/75.trs";;
let cp1 = Overlap.cp rs;;

let _ = multistep rs (f(f(V "___y3")))
*)

(* parallel_step R s = { t | s -||->R t } *)

let rec parallel_step rules = function
  | V _ as s -> [s]
  | F (f, ss) as s ->
      Listx.unique
	(s :: root_parallel_step rules s @
	 [ F (f, ts) | ts <- Listx.pi [ parallel_step rules s | s <- ss ] ])
and root_parallel_step rules s =
  Listx.unique
    [ substitute (pattern_match l s) r 
    | (l, r) <- rules;
      is_instance_of s l ]

