(* Non-termination check for R/S *)

open Term
open Substitution

let self_loop_rule (l, r) =
  List.exists (fun t -> is_instance_of t l) (subterms r)

let self_loop rules = List.exists self_loop_rule rules

let rec parallel = function
  | [], _ | _, [] -> false
  | i :: is, j :: js -> i <> j || parallel (is, js)

(*
let rec self_loop_positions l = function
  | V _ -> []
  | F (_, ts) as t -> 
      (* (if is_instance_of t l then [ [] ] else []) @ *)
      (if t = l then [ [] ] else []) @
      [ i :: p | i, ti <- Listx.ix ts; p <- self_loop_positions l ti ]
*)
let rec self_loop_positions l = function
  | V _ -> []
  | F (_, ts) as t -> 
      (if is_instance_of t l then [ [] ] else []) @ 
      [ i :: p | i, ti <- Listx.ix ts; p <- self_loop_positions l ti ]

(*
let duplicating_self_loop_rule (l, r) =
  List.exists parallel 
    [ p, q | p <- variable_positions r; q <- self_loop_positions l r ]
*)
let duplicating_self_loop_rule (l, r) =
  let ok (p, q) = 
     parallel (p, q) &&
     let subst = pattern_match l (subterm_at q r) in
     match subterm_at p r with
     | V x as r_p -> List.mem x (variables (substitute subst r_p))
     | _ -> failwith "Rsn.duplicating_self_loop_rule" in
  List.exists ok
    [ p, q | p <- variable_positions r; q <- self_loop_positions l r ]

let duplicating_self_loop rules = 
  List.exists duplicating_self_loop_rule rules

let not_sn strict_rules weak_rules =
  self_loop strict_rules ||
  (strict_rules <> [] && duplicating_self_loop weak_rules)
