{
open Smt2_parser
open Lexing
open Parsing
open Format

(* exception Error of (int * int * string) *)
let unsupport lexbuf =
  let curr = lexbuf.Lexing.lex_curr_p in
  let line = curr.Lexing.pos_lnum in
  let cnum = curr.Lexing.pos_cnum - curr.Lexing.pos_bol in
  let tok = Lexing.lexeme lexbuf in
  Format.eprintf "ignore line: %d line, %d column, token \"%s\"@." line cnum tok

let exit' () = Format.eprintf "Smt2 is killed"; exit 1
}
(* restrict to *)
(* let num = '-' * ([ '0'-'9' ] + ) *)
let name = ['A'-'Z' 'a'-'z' '0'-'9' '-' '+' '*' '#' '_' '\'' ':'] +


rule evidence = parse
  | [' ' '\t']   { evidence lexbuf }
  | '\n'         { new_line lexbuf; evidence lexbuf }
  | "sat"        { SAT }
  | "unsat"      { UNSAT }
  | "unknown"    { exit' () }
  | "model"      { MODEL }
  | "define-fun" { FUN }
  | "Int"        { INT }
  | "Real"       { REAL }
  | "Bool"       { BOOL }
(*  | num as n    { NUM (int_of_string n) } *)
  | name as v    { WORD v }
  | "="          { EQ }
  | "-"          { SIGN }
  | "()"         { UNIT }
  | "("          { LPAREN }
  | ")"          { RPAREN }
  | "true"       { TRUE }
  | "false"      { FALSE }
  | eof          { EOF }
  | _ { unsupport lexbuf; new_line lexbuf; evidence lexbuf }
