%{
open Lexing
open Parsing

type datatype = Int | Real

let syntax_error msg =
  let p = symbol_start_pos () in
  Format.eprintf "File %S at line %d, character %d:@.%s@." 
    p.pos_fname p.pos_lnum (p.pos_cnum - p.pos_bol + 1) msg;
  exit 1

let convert name datatype (sign,value) =
  match datatype with
    Int when sign -> Form.I (name, - (int_of_string value))
  | Int -> Form.I (name, int_of_string value)
  | Real when sign -> Form.R (name, -. (float_of_string value))
  | Real -> Form.R (name, float_of_string value)

%}

%token<string> WORD
%token TRUE FALSE UNIT
%token EQ MODEL FUN BOOL INT REAL SIGN
%token TUPLE
%token LPAREN RPAREN
%token SAT UNSAT
%token EOF
%start sat sat_proof
%type <bool > sat
%type <Form.model option > sat_proof

%%

sat:
    SAT   { true }
  | UNSAT { false }
;
sat_proof:
    SAT get_model { Some $2 }
  | UNSAT { None }
;
get_model:
    LPAREN MODEL eqs RPAREN { $3 }
  | { [] }
;
eqs:
    eq eqs { $1 :: $2 }
  |        { [] }
;
// current implementation supports only Int, Real, or Bool
eq:
    LPAREN FUN name UNIT BOOL boolean RPAREN { B ($3, $6) }
  | LPAREN FUN name UNIT INT value RPAREN { convert $3 Int $6 }
  | LPAREN FUN name UNIT REAL value RPAREN { convert $3 Real $6 }
;
name:
  WORD { $1 }
;
boolean:
    TRUE  { true  }
  | FALSE { false }
value:
    WORD { (false, $1) }
  | LPAREN SIGN WORD RPAREN { (true, $3) }
