open Term

(* single simple step *)
type step    = t -> t list
(* full step *)
type rewrite = t * (Rule.t * position) list * t
type stepS   = t -> rewrite list
type stepSs  = t -> rewrite list list

val rewrite_a     : Trs.t -> t -> t
val rewrite       : Trs.t -> step
val rewrite_at    : Trs.t -> position -> step
val parallel_step : Trs.t -> step
val multi_step    : Trs.t -> step
(* special *)
val stepS          : Trs.t -> stepS
val parallel_stepS : Trs.t -> stepS
val multi_stepS    : Trs.t -> stepS
(* rewrite k-times *)
val k_stepS  : int -> Trs.t -> stepS
val k_stepSs : int -> Trs.t -> stepSs
val k_step   : int -> Trs.t -> step
(* and including zero step (i.e. '=')*)
val less_k_stepSs : int -> Trs.t -> stepSs
val less_k_step   : int -> Trs.t -> step

(* predicate *)
val is_NF : Trs.t -> t -> bool

(* need terminating TRS *)
val normalform  : Trs.t -> t -> t
val normalforms : Trs.t -> t -> t list

(* combinators *)
val bind         : step -> t list -> t list
val (>>)         : step -> step -> step
val bindS        : stepS -> rewrite list -> rewrite list
val (>>>)        : stepS-> stepS -> stepS
val such_that    : (rewrite -> bool) -> rewrite list -> rewrite list
val position_is  : (position list -> bool) -> rewrite list -> rewrite list
val including_variables: string list -> stepS -> t -> t list
val including_variablesS: string list -> stepS -> stepS
val rev_including_variables: string list -> stepS -> t -> t list
val rev_including_variablesS: string list -> stepS -> stepS

(* utilities *)
val sources       : rewrite list -> t list
val reducts       : rewrite list -> t list
val rules         : rewrite list -> Rule.t list
val positions     : rewrite list -> position list
val source        : rewrite -> t
val reduct        : rewrite -> t
val rules_and_positions : rewrite list -> (Rule.t * position) list
val last          : rewrite list -> rewrite
val last_term     : rewrite list -> t
val non_trivials  : rewrite list -> rewrite list
val stepS2step    : stepS -> step
val show_rewrite  : rewrite -> unit
val show_rewrite_rev : rewrite -> unit
val show_stepS    : rewrite list list -> unit

(* cache functions *)
val cache_on      : unit -> unit
val cache_off     : unit -> unit
