(* $Id: term.mli,v 1.8 2005/07/13 11:46:23 nao Exp $ *)

(** Term operations *)

type t = 
  | V of string
  | F of string * t list

type binding = string * t

type position = int list

type subst = binding list

val print : Format.formatter -> t -> unit
val sprint : t -> string
val print_subst : Format.formatter -> (string * t) list -> unit
val print_position : Format.formatter -> int list -> unit

(* symbols *)
val variables_list : t -> string list

val variables : t -> string list

val variables_at : position list -> t -> string list

val functions_list : t -> string list

val functions : t -> string list

val count_variable : string -> t -> int

val term_size : t -> int

val signature : t -> Signature.t

val root : t -> string

(* terms *)
val subterms : t -> t list

val proper_subterms : t -> t list

val subterms_with_positions : t -> (t * position) list

val direct_subterms : t -> t list

val is_variable : t -> bool

val is_subterm : t -> t -> bool

val is_proper_subterm : t -> t -> bool

val count_variables : t -> string -> int

val linear : t -> bool

val flatten : string list -> t -> t

val unflatten : string list -> t -> t

(* substitution *)
val substitute : subst -> t -> t

val replace : t -> t -> position -> t

(* positions *)
val positions : t -> position list

val variable_positions : t -> position list

val function_positions : t -> position list

val subterm_at : position -> t -> t

(* NOTE: if a position is incorrect then this ignore it *)
val subterms_at : position list -> t -> t list

val is_subterm_at : position -> t -> t -> bool

val positions_of : t -> t -> position list

(* renaming *)
val ren : t -> t

val rename : t -> t

val fresh : unit -> string

val new_var : unit -> t

val new_const : unit -> t
