open Term

type t = Rule.t list

(* initialize to standard variable name *)
val init : t -> t

(* add unique numbers to rules *)
val label : t -> unit

(* symbols *)
val variables  : t -> string list
val functions  : t -> string list

val def   : Rule.t -> string
val cons  : Rule.t -> string list
val defs  : t -> string list
val conss : t -> string list

(* subterms *)
val subterms : t -> Term.t list

(* predicate *)
val linear      : t -> bool
val left_linear : t -> bool
val non_erase   : t -> bool
val variant     : t -> t -> bool

(* substitution *)
val subst          : (string * Term.t) list -> t -> t
val rename         : t -> t

(* utill *)
val sort : t -> t
val inverse : t -> t

(* printer *)
val sprint_rule     : Rule.t -> string

val sprint_rules    : t -> string
val print_rules     : t -> unit

(* val sprint_overlaps : (Rule.t * position * Rule.t) list -> string *)
(* val print_overlaps  : (Rule.t * position * Rule.t) list -> unit *)

(* val sprint_cp       : (t * position * t * t) -> string *)
(* val print_cp        : (t * position * t * t) -> unit *)
