%token<string> WORD
%token COST CORE
%token EQ
%token TUPLE
%token LPAREN RPAREN
%token SAT UNSAT
%token EOF
%start sat max_sat
%type <(string list * string list) list option > sat
%type <((string list * string list) list * int list * int) option > max_sat

%%

sat:
  satisfy EOF { $1 }
;
satisfy:
  | SAT eqs { Some $2 }
  | UNSAT { None }
;
eqs:
  | eq eqs { $1 :: $2 }
  |        { [] }
;
eq:
  LPAREN EQ data data RPAREN { $3,$4 }
;
data:
    WORD { [$1] }
  | LPAREN TUPLE seq RPAREN { $3 }
;
seq:
  | WORD seq { $1 :: $2 }
  |          { [] }
;

max_sat:
  | SAT core eqs cost EOF { Some ($3, $2, $4) }
  | UNSAT core EOF        { None }
;
core:
  | CORE nums { $2  }
  |           { [0] }
;
cost:
  | COST WORD { int_of_string $2 }
  | { 0 }
;
nums:
  | WORD { [int_of_string $1] }
  | WORD nums { int_of_string $1 :: $2 }
;
